(() => {
    'use strict';

    /// 移動場所選択用のウインドウ
    function Window_MoveDestination() {
        this.initialize.apply(this, arguments);
    }

    Window_MoveDestination.prototype = Object.create(Window_Command.prototype);
    Window_MoveDestination.prototype.constructor = Window_MoveDestination;

    // 移動先のセット処理
    // 追加するかどうかはスイッチを参照
    Window_MoveDestination.prototype.makeCommandList = function() {
        this.addCommand("Gランク", "map1", true, { mapId: 4, x: 10, y: 7 });
        if ($gameSwitches.value(1)) {
            this.addCommand("Fランク", "map2", true, { mapId: 6, x: 10, y: 7 });
        }
        if ($gameSwitches.value(2)) {
            this.addCommand("Eランク", "map3", true, { mapId: 7, x: 10, y: 7 });
        }
        if ($gameSwitches.value(3)) {
            this.addCommand("Dランク", "map4", true, { mapId: 8, x: 10, y: 7 });
        }
        if ($gameSwitches.value(4)) {
            this.addCommand("Cランク", "map5", true, { mapId: 9, x: 10, y: 7 });
        }
        if ($gameSwitches.value(5)) {
            this.addCommand("Bランク", "map6", true, { mapId: 10, x: 10, y: 7 });
        }
        if ($gameSwitches.value(6)) {
            this.addCommand("Aランク", "map7", true, { mapId: 11, x: 10, y: 7 });
        }
        if ($gameSwitches.value(7)) {
            this.addCommand("Sランク", "map8", true, { mapId: 12, x: 10, y: 7 });
        }
    };

    // 決戦場所に移動する用のシーン
    window.Scene_Move = function() {
        this.initialize.apply(this, arguments);
    }

    // 背景用にメニューベースを継承
    Scene_Move.prototype = Object.create(Scene_MenuBase.prototype);
    Scene_Move.prototype.constructor = Scene_Move;

    Scene_Move.prototype.initialize = function() {
        Scene_MenuBase.prototype.initialize.call(this);
    };

    Scene_Move.prototype.create = function() {
        Scene_MenuBase.prototype.create.call(this);
        this.createDestinationWindow();
    };

    // 移動先ウインドウの作成処理
    Scene_Move.prototype.createDestinationWindow = function() {
        const rect = this.destinationWindowRect();
        this._destWindow = new Window_MoveDestination(rect);
        this._destWindow.setHandler("ok", this.onDestinationOk.bind(this));
        this._destWindow.setHandler("cancel", this.popScene.bind(this));
        this.addWindow(this._destWindow);
    };

    // 移動先ウインド表示用の矩形
    Scene_Move.prototype.destinationWindowRect = function() {
        const ww = Graphics.boxWidth / 2;
        const wh = this.calcWindowHeight(6, true);
        const wx = (Graphics.boxWidth - ww) / 2;
        const wy = (Graphics.boxHeight - wh) / 2;
        return new Rectangle(wx, wy, ww, wh);
    };

    // 移動処理表示用の矩形
    Scene_Move.prototype.onDestinationOk = function() {
        const data = this._destWindow.currentExt();
        SceneManager.pop();

        // 移動処理
        $gamePlayer.reserveTransfer(data.mapId, data.x, data.y, 2, 0);
    };

})();